<?php
// Filter POST & GET
function filter($data)
{ //Filters data against security risks.
    if (is_array($data)) {
        foreach ($data as $key => $element) {
            $data[$key] = filter($element);
        }
    } else {
        $data = trim(htmlentities(strip_tags($data)));
        if (get_magic_quotes_gpc())
            $data = stripslashes($data);
        $data = mysql_real_escape_string($data);
    }
    return $data;
}
function filter2($data)
{ //Filters data against security risks.
    return str_replace("'", "`", $data);
}

function hp62($nohp)
{
    // Menghapus karakter yang tidak diperlukan
    $nohp = str_replace(["+", " ", "(", ")", "."], "", $nohp);
    $nohp = str_replace("-", "", $nohp); // Menghapus tanda strip (-)

    // Mengecek apakah nomor hanya mengandung karakter angka
    if (!preg_match('/[^0-9]/', trim($nohp))) {
        // Jika nomor diawali dengan 62
        if (substr(trim($nohp), 0, 2) == '62') {
            return trim($nohp);
        }
        // Jika nomor diawali dengan 0
        elseif (substr(trim($nohp), 0, 1) == '0') {
            return '62' . substr(trim($nohp), 1);
        }
    }

    // Jika nomor tidak valid, mengembalikan nilai default
    return null; // atau return "Nomor tidak valid";
}
function acakpass($kar, $level = "")
{
    if ($level == "LOW" || $level == "") {
        $acak = strtoupper(substr(str_shuffle(str_repeat("23456789abcdefghijklmnpqrstuvwxyz", $kar)), 0, $kar));
    } else if ($level == "HIGH") {
        $acak = strtoupper(substr(str_shuffle(str_repeat("23456789abcdefghijklmnpqrstuvwxyz@%#()[]&-_+?!", $kar)), 0, $kar));
    }
    return $acak;
}
// Echo with Stripslashes
function echoo($data)
{
    echo stripslashes(stripslashes($data));
}


// CRUD FUNCTIONS

function dbInsert($table_name, $form_data)
{
    // retrieve the keys of the array (column titles)
    $fields = array_keys($form_data);

    // build the query
    $sql = "INSERT INTO " . $table_name . "
    (`" . implode('`,`', $fields) . "`)
    VALUES('" . implode("','", $form_data) . "')";

    // run and return the query result resource
    return mysql_query($sql);
}

function dbReplace($table_name, $form_data)
{
    // retrieve the keys of the array (column titles)
    $fields = array_keys($form_data);

    // build the query
    $sql = "REPLACE INTO " . $table_name . "
    (`" . implode('`,`', $fields) . "`)
    VALUES('" . implode("','", $form_data) . "')";

    // run and return the query result resource
    return mysql_query($sql);
}

// the where clause is left optional incase the user wants to delete every row!
function dbSelect($table_name, $where_clause = '')
{
    // check for optional where clause
    $whereSQL = '';
    if (!empty($where_clause)) {
        // check to see if the 'where' keyword exists
        if (substr(strtoupper(trim($where_clause)), 0, 5) != 'WHERE') {
            // not found, add keyword
            $whereSQL = " WHERE " . $where_clause;
        } else {
            $whereSQL = " " . trim($where_clause);
        }
    }
    // build the query
    $sql = "SELECT * FROM " . $table_name . $whereSQL;

    // run and return the query result resource
    return mysql_query($sql);
}

// again where clause is left optional
function dbUpdate($table_name, $form_data, $where_clause = '')
{
    // check for optional where clause
    $whereSQL = '';
    if (!empty($where_clause)) {
        // check to see if the 'where' keyword exists
        if (substr(strtoupper(trim($where_clause)), 0, 5) != 'WHERE') {
            // not found, add key word
            $whereSQL = " WHERE " . $where_clause;
        } else {
            $whereSQL = " " . trim($where_clause);
        }
    }
    // start the actual SQL statement
    $sql = "UPDATE " . $table_name . " SET ";

    // loop and build the column /
    $sets = array();
    foreach ($form_data as $column => $value) {
        $sets[] = "`" . $column . "` = '" . $value . "'";
    }
    $sql .= implode(', ', $sets);

    // append the where statement
    $sql .= $whereSQL;

    // run and return the query result
    return mysql_query($sql);
}


// the where clause is left optional incase the user wants to delete every row!
function dbDelete($table_name, $where_clause = '')
{
    // check for optional where clause
    $whereSQL = '';
    if (!empty($where_clause)) {
        // check to see if the 'where' keyword exists
        if (substr(strtoupper(trim($where_clause)), 0, 5) != 'WHERE') {
            // not found, add keyword
            $whereSQL = " WHERE " . $where_clause;
        } else {
            $whereSQL = " " . trim($where_clause);
        }
    }
    // build the query
    $sql = "DELETE FROM " . $table_name . $whereSQL;

    // run and return the query result resource
    return mysql_query($sql);
}

function notif($query)
{
    if ($query) {
        $notif = "sukses";
    } else {
        $notif = "gagal";
    }
    return $notif;
}
// END CRUD FUNCTIONS


function alfanumber($data)
{
    $data = preg_replace("/[^A-Za-z0-9]/", "", $data);
    return $data;
}
// function alfanumber($data){
// 	$data = preg_replace("/[^A-Za-z0-9_]/","",$data);
// 	return $data;
// }
function fsearch($data)
{
    $data = preg_replace("/[^A-Za-z0-9\'.,]/", "", $data);
    return $data;
}

function numberonly($data)
{
    preg_replace("/[^0-9,.]/", "", $data);
    return $data;
}

function digit($data)
{
    preg_replace("/[^0-9]/", "", $data);
    $data = str_replace(".", "", $data);
    $data = str_replace(",", "", $data);
    return $data;
}

function juser($hak)
{
    if ($hak == "user") {
        $jadmin = "Pegawai";
    } else
        if ($hak == "admin") {
            $jadmin = "Admin Standar";
        } else
            if ($hak == "superadmin") {
                $jadmin = "Superadmin";
            } else {
                $jadmin = "?";
            }
    return $jadmin;
}

function ribu($angka)
{
    if ($angka != "") {
        return number_format($angka, 0, ",", ".");
    } else
        return 0;
}
function ribukoma($angka)
{
    if ($angka != "") {
        return number_format($angka, 0, ".", ",");
    } else
        return 0;
}

function rp($angka)
{
    if ($angka != "") {
        return "Rp " . ribu($angka) . ",-";
    } else
        return "Rp 0,-";
}

function getdata($tabel, $kolom, $kunci, $return)
{
    $select = dbSelect($tabel, "WHERE $kolom = '$kunci' LIMIT 1");
    $data = mysql_fetch_array($select);
    return $data[$return];
}

function indotime($timestamp, $timetrue)
{
    $tm = explode(" ", $timestamp);
    $tgl = explode("-", $tm[0]);
    $tgl = $tgl[2] . "/" . $tgl[1] . "/" . $tgl[0];
    if ($timetrue == true) {
        return $tgl . " " . $tm[1];
    } else {
        return $tgl;
    }
}
function updatedindo($timestamp)
{
    $pecah = explode(" ", $timestamp);
    $tgl = explode("-", $pecah[0]);
    $time = $pecah['1'];
    if ($tgl[1] != "10") {
        $bulan = intval(str_replace("0", "", $tgl[1])) - 1;
    } else {
        $bulan = intval($tgl[1]) - 1;
    }
    $arrnamabulan = array("Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Agt", "Spt", "Okt", "Nov", "Des");
    // return dd-mm-yyyy HH:ii:ss
    return $tgl[2] . " " . $arrnamabulan[$bulan] . " " . $tgl[0] . " " . $time;
}

function konversi($x)
{

    $x = abs($x);
    $angka = array("", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
    $temp = "";

    if ($x < 12) {
        $temp = " " . $angka[$x];
    } else if ($x < 20) {
        $temp = konversi($x - 10) . " belas ";
    } else if ($x < 100) {
        $temp = konversi($x / 10) . " puluh " . konversi($x % 10);
    } else if ($x < 200) {
        $temp = " seratus " . konversi($x - 100);
    } else if ($x < 1000) {
        $temp = konversi($x / 100) . " ratus " . konversi($x % 100);
    } else if ($x < 2000) {
        $temp = " seribu " . konversi($x - 1000);
    } else if ($x < 1000000) {
        $temp = konversi($x / 1000) . " ribu " . konversi($x % 1000);
    } else if ($x < 1000000000) {
        $temp = konversi($x / 1000000) . " juta " . konversi($x % 1000000);
    } else if ($x < 1000000000000) {
        $temp = konversi($x / 1000000000) . " milyar " . konversi($x % 1000000000);
    }

    return $temp;
}

function tkoma($x)
{
    $str = stristr($x, ",");
    $ex = explode(',', $x);

    if (($ex[1] / 10) >= 1) {
        $a = abs($ex[1]);
    }
    $string = array("nol", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
    $temp = "";

    $a2 = $ex[1] / 10;
    $pjg = strlen($str);
    $i = 1;


    if ($a >= 1 && $a < 12) {
        $temp .= " " . $string[$a];
    } else if ($a > 12 && $a < 20) {
        $temp .= konversi($a - 10) . " belas";
    } else if ($a > 20 && $a < 100) {
        $temp .= konversi($a / 10) . " puluh" . konversi($a % 10);
    } else {
        if ($a2 < 1) {

            while ($i < $pjg) {
                $char = substr($str, $i, 1);
                $i++;
                $temp .= " " . $string[$char];
            }
        }
    }
    return $temp;
}

function terbilang($x)
{
    if ($x < 0) {
        $hasil = "minus " . trim(konversi(x));
    } else {
        $poin = trim(tkoma($x));
        $hasil = trim(konversi($x));
    }

    if ($poin) {
        $hasil = $hasil . " koma " . $poin;
    } else {
        $hasil = $hasil;
    }
    return $hasil;
}

function bulan($bln)
{
    if ($bln == 1) {
        $namabulan = "Januari";
    } else
        if ($bln == 2) {
            $namabulan = "Februari";
        } else
            if ($bln == 3) {
                $namabulan = "Maret";
            } else
                if ($bln == 4) {
                    $namabulan = "April";
                } else
                    if ($bln == 5) {
                        $namabulan = "Mei";
                    } else
                        if ($bln == 6) {
                            $namabulan = "Juni";
                        } else
                            if ($bln == 7) {
                                $namabulan = "Juli";
                            } else
                                if ($bln == 8) {
                                    $namabulan = "Agustus";
                                } else
                                    if ($bln == 9) {
                                        $namabulan = "September";
                                    } else
                                        if ($bln == 10) {
                                            $namabulan = "Oktober";
                                        } else
                                            if ($bln == 11) {
                                                $namabulan = "November";
                                            } else
                                                if ($bln == 12) {
                                                    $namabulan = "Desember";
                                                }
    return $namabulan;
}

function haritanggal($tanggal, $cetak_hari = true)
{
    $hari = array(
        1 => 'Senin',
        'Selasa',
        'Rabu',
        'Kamis',
        'Jum`at',
        'Sabtu',
        'Minggu'
    );

    $bulan = array(
        1 => 'Januari',
        'Februari',
        'Maret',
        'April',
        'Mei',
        'Juni',
        'Juli',
        'Agustus',
        'September',
        'Oktober',
        'November',
        'Desember'
    );
    $split = explode('-', $tanggal);
    $tgl_indo = $split[2] . ' ' . $bulan[(int) $split[1]] . ' ' . $split[0];

    if ($cetak_hari) {
        $num = date('N', strtotime($tanggal));
        return $hari[$num] . ', ' . $tgl_indo;
    }
    return $tgl_indo;
}

function hari($tanggal)
{
    $hari = array(
        1 => 'Senin',
        'Selasa',
        'Rabu',
        'Kamis',
        'Jum`at',
        'Sabtu',
        'Minggu'
    );

    $split = explode('-', $tanggal);
    $tgl_indo = $split[2] . ' ' . $bulan[(int) $split[1]] . ' ' . $split[0];

    $num = date('N', strtotime($tanggal));
    return $hari[$num];

    return $tgl_indo;
}

function makeInt($angka)
{

    if ($angka < -0.0000001) {

        return ceil($angka - 0.0000001);

    } else {

        return floor($angka + 0.0000001);

    }

}

function akhirbulan($year, $month)
{
    return date("Y-m-d", strtotime('-1 second', strtotime('+1 month', strtotime($month . '/01/' . $year . ' 00:00:00'))));
}

function hijriah($tanggal)
{

    $array_bulan = array(
        "Muharram",
        "Safar",
        "Rabiul Awwal",
        "Rabiul Akhir",
        "Jumadil Awwal",
        "Jumadil Akhir",
        "Rajab",
        "Sya’ban",
        "Ramadhan",
        "Syawwal",
        "Dzulqaidah",
        "Dzulhijjah"
    );

    $date = makeInt(substr($tanggal, 8, 2));

    $month = makeInt(substr($tanggal, 5, 2));

    $year = makeInt(substr($tanggal, 0, 4));

    if (($year > 1582) || (($year == "1582") && ($month > 10)) || (($year == "1582") && ($month == "10") && ($date > 14))) {

        $jd = makeInt((1461 * ($year + 4800 + makeInt(($month - 14) / 12))) / 4) +

            makeInt((367 * ($month - 2 - 12 * (makeInt(($month - 14) / 12)))) / 12) -

            makeInt((3 * (makeInt(($year + 4900 + makeInt(($month - 14) / 12)) / 100))) / 4) +

            $date - 32075;

    } else {

        $jd = 367 * $year - makeInt((7 * ($year + 5001 + makeInt(($month - 9) / 7))) / 4) +

            makeInt((275 * $month) / 9) + $date + 1729777;

    }

    $wd = $jd % 7;

    $l = $jd - 1948440 + 10632;

    $n = makeInt(($l - 1) / 10631);

    $l = $l - 10631 * $n + 354;

    $z = (makeInt((10985 - $l) / 5316)) * (makeInt((50 * $l) / 17719)) + (makeInt($l / 5670)) * (makeInt((43 * $l) / 15238));

    $l = $l - (makeInt((30 - $z) / 15)) * (makeInt((17719 * $z) / 50)) - (makeInt($z / 16)) * (makeInt((15238 * $z) / 43)) + 29;

    $m = makeInt((24 * $l) / 709);

    $d = $l - makeInt((709 * $m) / 24);

    $y = 30 * $n + $z - 30;

    $g = $m - 1;

    $final = "$d $array_bulan[$g] $y H";

    return $final;

}

function romawi($angka)
{
    $hsl = "";
    if ($angka < 1 || $angka > 5000) {
        // Statement di atas buat nentuin angka ngga boleh dibawah 1 atau di atas 5000
        $hsl = "Batas Angka 1 s/d 5000";
    } else {
        while ($angka >= 1000) {
            // While itu termasuk kedalam statement perulangan
            // Jadi misal variable angka lebih dari sama dengan 1000
            // Kondisi ini akan di jalankan
            $hsl .= "M";
            // jadi pas di jalanin , kondisi ini akan menambahkan M ke dalam
            // Varible hsl
            $angka -= 1000;
            // Lalu setelah itu varible angka di kurangi 1000 ,
            // Kenapa di kurangi
            // Karena statment ini mengambil 1000 untuk di konversi menjadi M
        }
    }


    if ($angka >= 500) {
        // statement di atas akan bernilai true / benar
        // Jika var angka lebih dari sama dengan 500
        if ($angka > 500) {
            if ($angka >= 900) {
                $hsl .= "CM";
                $angka -= 900;
            } else {
                $hsl .= "D";
                $angka -= 500;
            }
        }
    }
    while ($angka >= 100) {
        if ($angka >= 400) {
            $hsl .= "CD";
            $angka -= 400;
        } else {
            $angka -= 100;
        }
    }
    if ($angka >= 50) {
        if ($angka >= 90) {
            $hsl .= "XC";
            $angka -= 90;
        } else {
            $hsl .= "L";
            $angka -= 50;
        }
    }
    while ($angka >= 10) {
        if ($angka >= 40) {
            $hsl .= "XL";
            $angka -= 40;
        } else {
            $hsl .= "X";
            $angka -= 10;
        }
    }
    if ($angka >= 5) {
        if ($angka == 9) {
            $hsl .= "IX";
            $angka -= 9;
        } else {
            $hsl .= "V";
            $angka -= 5;
        }
    }
    while ($angka >= 1) {
        if ($angka == 4) {
            $hsl .= "IV";
            $angka -= 4;
        } else {
            $hsl .= "I";
            $angka -= 1;
        }
    }

    return ($hsl);
}

class Uploader
{
    private $destinationPath;
    private $errorMessage;
    private $extensions;
    private $maxSize;
    private $uploadName;
    public $name = 'Uploader';

    function setDir($path)
    {
        $this->destinationPath = $path;
    }

    function setMaxSize($sizeMB)
    {
        $this->maxSize = $sizeMB * (1024 * 1024);
    }

    function setExtensions($options)
    {
        $this->extensions = $options;
    }

    function setMessage($message)
    {
        $this->errorMessage = $message;
    }

    function getMessage()
    {
        return $this->errorMessage;
    }

    function getUploadName()
    {
        return $this->uploadName;
    }

    function setReturn($filename)
    {
        $this->ToReturn = $filename;
    }

    function getReturn()
    {
        return $this->ToReturn;
    }



    function uploadFile($fileBrowse)
    {
        $result = false;
        $size = $_FILES[$fileBrowse]["size"];
        $name = $_FILES[$fileBrowse]["name"];
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));

        $this->uploadName = $sesi . rand(100, 999) . "_" . $name;

        if (empty($name)) {
            $this->setMessage("File not selected ");
        } else if ($size > $this->maxSize) {
            $this->setMessage("Too large file !");
        } else if (in_array($ext, $this->extensions)) {
            if (!is_dir($this->destinationPath))
                mkdir($this->destinationPath);
            if (!is_dir($this->destinationPath . '/' . $ext))
                mkdir($this->destinationPath . '/' . $ext);

            if (file_exists($this->destinationPath . '/' . $ext . '/' . $this->uploadName))
                $this->setMessage("File already exists. !");
            else if (!is_writable($this->destinationPath . '/' . $ext))
                $this->setMessage("Destination is not writable !");
            else {

                $xtimg = array("jpg", "jpeg", "png", "gif");
                if (in_array($ext, $xtimg)) {

                    $uploadedfile = $_FILES[$fileBrowse]['tmp_name'];

                    if ($ext == "jpg" || $ext == "jpeg") {
                        $src = imagecreatefromjpeg($uploadedfile);
                    } else if ($ext == "png") {
                        $src = imagecreatefrompng($uploadedfile);
                    } else {
                        $src = imagecreatefromgif($uploadedfile);
                    }

                    list($width, $height) = getimagesize($uploadedfile);
                    if ($width > 800) {
                        $newwidth = 800;
                        $newheight = ($height / $width) * $newwidth;
                    } else {
                        $newwidth = $width;
                        $newheight = $height;
                    }
                    $tmp = imagecreatetruecolor($newwidth, $newheight);

                    if ($ext == "png" || $ext == "gif") {
                        imagealphablending($tmp, false);
                        imagesavealpha($tmp, true);
                        $transparent = imagecolorallocatealpha($tmp, 255, 255, 255, 127);
                        imagefilledrectangle($tmp, 0, 0, $newwidth, $newheight, $transparent);
                    }

                    imagecopyresampled($tmp, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
                    $filename = $this->destinationPath . '/' . $ext . '/' . $this->uploadName;

                    if ($ext == "jpg" || $ext == "jpeg") {
                        imagejpeg($tmp, $filename, 90);
                    } else if ($ext == "png") {
                        imagepng($tmp, $filename);
                    } else {
                        imagegif($tmp, $filename);
                    }

                    imagedestroy($src);
                    imagedestroy($tmp);
                } else {
                    // jika bukan gambar	
                    $xtfile = array("php", "js", "css", "php5", "html", "wml", "htm", "xml", "json");
                    if (!in_array($ext, $xtfile)) {
                        move_uploaded_file($_FILES[$fileBrowse]["tmp_name"], $this->destinationPath . '/' . $ext . '/' . $this->uploadName);
                    } else {
                        $this->setMessage("Jenis file terlarang!");
                    }
                }
                $filename = $this->destinationPath . '/' . $ext . '/' . $this->uploadName;
                $this->setReturn($filename);
                $result = true;

            }
        } else {
            $this->setMessage("Invalid file format !");
        }
        return $result;
    }



    function deleteUploaded($fileBrowse)
    {
        $name = $_FILES[$fileBrowse]["name"];
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        unlink($this->destinationPath . '/' . $ext . '/' . $this->uploadName);
    }
}

// Fungsi SEO URL
function seourl($tt)
{
    $tt = strtolower(str_replace("--", "-", preg_replace("/[^0-9a-zA-Z.]/i", '-', $tt)));
    return $tt;
}


function waktu2($waktu1, $waktu2)
{

    $tm = explode(" ", $waktu1);
    $tgl = explode("-", $tm[0]);
    $wkt = explode(":", $tm[1]);
    $wktu = $wkt[0] . ":" . $wkt[1];
    $tanggal1 = $tgl[2] . "-" . $tgl[1] . "-" . $tgl[0];
    $waktu1 = $tanggal1 . " " . $wktu;

    $tm2 = explode(" ", $waktu2);
    $tgl2 = explode("-", $tm2[0]);
    $wkt2 = explode(":", $tm2[1]);
    $wktu2 = $wkt2[0] . ":" . $wkt2[1];
    $tanggal2 = $tgl2[2] . "-" . $tgl2[1] . "-" . $tgl2[0];
    $waktu2 = $tanggal2 . " " . $wktu2;

    if ($tanggal1 == $tanggal2) {
        return "$tanggal1 ($wktu-$wktu2)";
    } else {
        return "$waktu1 s/d $waktu2";
    }
}
function waktu3($waktu1, $waktu2)
{
    // array bulan singkat
    $bulan = [
        1 => "Jan",
        "Feb",
        "Mar",
        "Apr",
        "Mei",
        "Jun",
        "Jul",
        "Agu",
        "Sep",
        "Okt",
        "Nov",
        "Des"
    ];

    $tanggal1 = date("d-m-Y", strtotime($waktu1));
    $tanggal2 = date("d-m-Y", strtotime($waktu2));

    // cek jika sama persis
    if ($tanggal1 == $tanggal2) {
        $d1 = date("d", strtotime($waktu1));
        $m1 = $bulan[(int) date("m", strtotime($waktu1))];
        $y1 = date("Y", strtotime($waktu1));
        return "$d1-$m1-$y1";
    }

    // pecah bagian tanggal, bulan, tahun
    $d1 = date("d", strtotime($waktu1));
    $m1 = (int) date("m", strtotime($waktu1));
    $y1 = date("Y", strtotime($waktu1));

    $d2 = date("d", strtotime($waktu2));
    $m2 = (int) date("m", strtotime($waktu2));
    $y2 = date("Y", strtotime($waktu2));

    // jika bulan dan tahun sama
    if ($m1 == $m2 && $y1 == $y2) {
        return "$d1 s/d $d2-{$bulan[$m1]}-$y1";
    } else {
        return "$d1-{$bulan[$m1]}-$y1 s/d $d2-{$bulan[$m2]}-$y2";
    }
}


function cekrandom($table, $random)
{
    $query = dbSelect($table, "WHERE kode='$random'");
    $cek = mysql_num_rows($query);
    if ($cek >= 1) {
        $hasil_random = date("ymdHis") . "" . rand(1000, 9999);
        $query2 = dbSelect($table, "WHERE kode='$hasil_random'");
        $cek2 = mysql_num_rows($query2);
        if ($cek2 >= 1) {
            cekrandom($table, $random);
        } else {
            return $hasil_random;
        }
    } else {
        return $random;
    }
}

function youtube_autoplay($url)
{
    $video_id = '';
    if (preg_match('/youtube\.com\/watch\?v=([^\&\?\/]+)/', $url, $id)) {
        $video_id = $id[1];
    } else if (preg_match('/youtube\.com\/embed\/([^\&\?\/]+)/', $url, $id)) {
        $video_id = $id[1];
    } else if (preg_match('/youtube\.com\/v\/([^\&\?\/]+)/', $url, $id)) {
        $video_id = $id[1];
    } else if (preg_match('/youtu\.be\/([^\&\?\/]+)/', $url, $id)) {
        $video_id = $id[1];
    }
    // $html = '<iframe width="560" height="315" src="https://www.youtube.com/embed/'.$video_id.'?autoplay=1" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>';
    $link_yt = "https://www.youtube.com/embed/'.$video_id.'?autoplay=1";
    return $link_yt;
}

function ytbid($url)
{
    $parts = parse_url($url);
    if (isset($parts['query'])) {
        parse_str($parts['query'], $qs);
        if (isset($qs['v'])) {
            return $qs['v'];
        } else if ($qs['vi']) {
            return $qs['vi'];
        }
    }
    if (isset($parts['path'])) {
        $path = explode('/', trim($parts['path'], '/'));
        return $path[count($path) - 1];
    }
    return false;
}
function kehadiran($user)
{
    $hari_ini = date("Y-m-d");
    $qagenda = mysql_query("SELECT COUNT(id) AS total FROM agenda WHERE status!='Dibatalkan' AND tanggal<='$hari_ini'");
    $agenda = mysql_fetch_assoc($qagenda);

    $qabsen = mysql_query("SELECT COUNT(id) AS total FROM kehadiran WHERE user='$user' AND status='Hadir'");
    $absen = mysql_fetch_assoc($qabsen);

    return round(($absen['total'] / $agenda['total']) * 100);
}
function kirimwa($number, $pesan, $file = "", $app_key_wa)
{
    $sql = dbSelect("config", "WHERE id='setting'");
    $cfg = mysql_fetch_assoc($sql);
    // if ($app_key_wa != '') {

    $file = str_replace("../", "", $file);
    $data = [
        'apikey' => $app_key_wa,
        'mtype' => 'text',
        'receiver' => $number,
        'text' => filter2($pesan)
    ];

    if ($file != "") {
        $data['mtype'] = "image";
        $data['url'] = $file;
    }

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $cfg['server_wa'] . '/api/send-message',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => http_build_query($data),
    ]);

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        // echo 'Curl error: ' . curl_error($curl);
        return false;
    }

    curl_close($curl);

    // Cetak respons mentah untuk debugging
    // echo 'Response: ' . $response . '<br>';

    $json = json_decode($response, true);

    // Cetak hasil json_decode untuk debugging
    // echo 'Decoded JSON: ' . print_r($json, true) . '<br>';

    if (json_last_error() !== JSON_ERROR_NONE) {
        // echo 'JSON decode error: ' . json_last_error_msg();
        // return false;
    }

    $data_log = [
        "nomor" => $number,
        "pesan" => $pesan,
        "status" => isset($json['status']) ? 'Success' : 'Failed',
        "ket" => isset($json['message']) ? $json['message'] : 'No message',
        "foto" => $file,
        "updated" => date("Y-m-d H:i:s")
    ];

    $dbInsert = dbInsert("wa_log", $data_log);

    return $json['status'];
    // }
}
function umur($tanggal_lahir)
{ // Menghitung selisih tahun 
    $tanggal_lahir = new DateTime($tanggal_lahir);
    $tanggal_sekarang = new DateTime('today');
    $umur = $tanggal_sekarang->diff($tanggal_lahir)->y;
    return $umur;
}
function umurmati($tgl_lahir, $tgl_mati)
{
    // Mengubah string tanggal menjadi objek DateTime
    $tanggalLahir = DateTime::createFromFormat('Y-m-d', $tgl_lahir);
    $tanggalMati = DateTime::createFromFormat('Y-m-d', $tgl_mati);

    // Hitung selisih antara tanggal lahir dan tanggal meninggal
    $interval = $tanggalLahir->diff($tanggalMati);

    // Kembalikan hasil dalam bentuk string
    return $interval->y;
}
function jarak_koordinat($value_koordinat1, $value_koordinat2)
{
    // Konversi derajat ke radian 
    $earthRadius = 6371000;
    // Radius Bumi dalam meter 
    $koordinat1 = explode(",", $value_koordinat1);
    $koordinat2 = explode(",", $value_koordinat2);
    $latFrom = deg2rad($koordinat1[0]);
    $lonFrom = deg2rad($koordinat1[1]);
    $latTo = deg2rad($koordinat2[0]);
    $lonTo = deg2rad($koordinat2[1]);
    $latDelta = $latTo - $latFrom;
    $lonDelta = $lonTo - $lonFrom;
    $a = sin($latDelta / 2) * sin($latDelta / 2) + cos($latFrom) * cos($latTo) * sin($lonDelta / 2) * sin($lonDelta / 2);
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $distance = $earthRadius * $c;
    return round($distance / 1000, 2);
    // Jarak dalam meter 
}
function tgl_bulan($tanggal)
{
    $arr_tgl = explode("-", $tanggal);
    return $arr_tgl[2] . " " . bulan($arr_tgl[1]) . " " . $arr_tgl[0];
}

function generateNoid($jenis)
{
    $jenis = strtolower($jenis);
    $prefix = "";

    // Tentukan prefix berdasarkan jenis
    if ($jenis == "supllier") {
        $prefix = "SPL";
    } elseif ($jenis == "operator") {
        $prefix = "OPR";
    } elseif ($jenis == "grade") {
        $prefix = "GRD";
    } else {
        $prefix = strtoupper(substr($jenis, 0, 3)); // fallback default
    }

    // Ambil noid terakhir dari database
    $query = mysql_query("SELECT noid FROM sdm WHERE jenis='$jenis' ORDER BY noid DESC LIMIT 1");
    $data = mysql_fetch_assoc($query);

    $tahunSekarang = date("y");
    $noUrutBaru = "0001"; // default awal jika belum ada

    if ($data && isset($data['noid'])) {
        $lastNoid = $data['noid'];               // Contoh: SPL-250005
        $numericPart = substr($lastNoid, 4);     // Hasil: 250005
        $tahunLama = substr($numericPart, 0, 2); // Hasil: 25
        $noUrutLama = substr($numericPart, 2);   // Hasil: 0005

        if ($tahunLama == $tahunSekarang) {
            $noUrutBaru = str_pad(((int) $noUrutLama + 1), 4, "0", STR_PAD_LEFT);
        }
    }

    return $prefix . "-" . $tahunSekarang . $noUrutBaru;

}
function updateDibayarNota($idnota)
{
    if ($idnota != '') {
        // ambil pembayaran
        $qpembayaran = mysql_query("SELECT SUM(keluar) AS total FROM keuangan WHERE keluar!='' AND idnota='$idnota'");
        $dpembayaran = mysql_fetch_assoc($qpembayaran);
        $sql = "UPDATE nota SET dibayar='$dpembayaran[total]' WHERE idnota='$idnota' LIMIT 1";
        mysql_query($sql);
    }
}
function updateBahanBakarSPK($idspk)
{
    if ($idspk != '') {
        // ambil pembayaran
        $qpembayaran = mysql_query("SELECT SUM(keluar) AS total, SUM(liter) AS total_liter FROM keuangan WHERE keluar!='' AND idnota='$idspk' AND kategori='001'");
        $dpembayaran = mysql_fetch_assoc($qpembayaran);
        $sql = "UPDATE spk SET bahan_bakar_liter='$dpembayaran[total_liter]', bahan_bakar_total='$dpembayaran[total]' WHERE idspk='$idspk' LIMIT 1";
        mysql_query($sql);
    }
}
function hitung_sisa($idspk, $barang, $jenis = 'vol')
{
    if ($jenis == "vol") {
        // ambil target
        $qtarget = mysql_query("SELECT SUM(volume) AS total_volume FROM kayu_target WHERE idspk='$idspk' AND barang='$barang'");
        $dtarget = mysql_fetch_assoc($qtarget);

        // ambil hasil diproduksi
        $qhasil = mysql_query("SELECT SUM(volume) AS total_volume FROM kayu_masuk WHERE idnota='$idspk' AND barang='$barang'");
        $dhasil = mysql_fetch_assoc($qhasil);

        // hitung selisih
        $selisih = $dhasil['total_volume'] - $dtarget['total_volume'];

        // if ($dhasil['total_volume'] > $dtarget['total_volume']) {
        //     return "+" . abs($selisih); // pastikan nilai positif
        // } else {
        //     return $selisih;
        // }
        return $selisih;
    }

    if ($jenis == "pcs") {
        // ambil target
        $qtarget = mysql_query("SELECT SUM(jumlah_batang) AS total_jumlah_batang FROM kayu_target WHERE idspk='$idspk' AND barang='$barang'");
        $dtarget = mysql_fetch_assoc($qtarget);

        // ambil hasil diproduksi
        $qhasil = mysql_query("SELECT SUM(jumlah_batang) AS total_jumlah_batang FROM kayu_masuk WHERE idnota='$idspk' AND barang='$barang'");
        $dhasil = mysql_fetch_assoc($qhasil);

        // hitung selisih
        $selisih = $dhasil['total_jumlah_batang'] - $dtarget['total_jumlah_batang'];

        // if ($selisih) {
        //     return "+" . abs($selisih); // pastikan nilai positif
        // } else {
        //     return $selisih;
        // }
        return $selisih;
    }
}
function hitung_tercapai($idspk, $barang, $jenis = 'vol')
{
    if ($jenis == "vol") {
        // ambil hasil diproduksi
        $qhasil = mysql_query("SELECT SUM(volume) AS total_volume FROM kayu_masuk WHERE idnota='$idspk' AND barang='$barang'");
        $dhasil = mysql_fetch_assoc($qhasil);
        return $dhasil['total_volume'];
    }

    if ($jenis == "pcs") {
        // ambil hasil diproduksi
        $qhasil = mysql_query("SELECT SUM(jumlah_batang) AS total_jumlah_batang FROM kayu_masuk WHERE idnota='$idspk' AND barang='$barang'");
        $dhasil = mysql_fetch_assoc($qhasil);
        return $dhasil['total_jumlah_batang'];
    }
}
function hitung_jumlah_hari($tgl_mulai, $tgl_selesai, $inklusif = true)
{
    $start = new DateTime($tgl_mulai);
    $end = new DateTime($tgl_selesai);

    // Hitung selisih hari
    $jumlah_hari = $start->diff($end)->days;

    // Tambah 1 jika inklusif
    if ($inklusif) {
        $jumlah_hari += 1;
    }

    return $jumlah_hari;
}
function formatindo($date)
{
    // Pastikan input bukan kosong atau NULL
    if (empty($date) || $date == '0000-00-00') {
        return '-';
    }

    // Konversi tanggal ke format d/m/Y
    $tanggal = date('d/m/Y', strtotime($date));
    return $tanggal;
}

function update_keuangan_nota_angkut($idnotaangkut)
{
    // ambil data nota angkut
    $qnotaangkut = mysql_query("SELECT * FROM nota_angkut WHERE idnotaangkut='$idnotaangkut' LIMIT 1");
    $cnotaangkut = mysql_num_rows($qnotaangkut);
    if ($idnotaangkut != '' && $cnotaangkut > 0) {
        $dnotaangkut = mysql_fetch_assoc($qnotaangkut);
        // ambil 	total_awal, total_akhir, total, terbayar
        // ambil daftar_kayu
        $qdaftar_kayu = mysql_query("SELECT SUM(jumlah) AS total_awal, SUM(jumlah_akhir) AS total_akhir FROM kayu_keluar WHERE idnota='$idnotaangkut'");
        $ddaftar_kayu = mysql_fetch_assoc($qdaftar_kayu);
        $total_awal = $ddaftar_kayu['total_awal']; // diambil dari daftar kayu total awal
        $total_akhir = $ddaftar_kayu['total_akhir']; // diambil dari daftar kayu total akhir
        $total = ($total_akhir - $dnotaangkut['potongan']) + $dnotaangkut['biaya_tambahan'];
        // ambil keuangan masuk
        $qterbayar = mysql_query("SELECT SUM(masuk) as total FROM keuangan WHERE idnota='$idnotaangkut' AND masuk!='' AND keluar='' LIMIT 1");
        $dterbayar = mysql_fetch_assoc($qterbayar);
        $terbayar = $dterbayar['total']; // di ambil dari keuangan masuk !='' WHERE idnotaangkut='$idnotaangkut'
        mysql_query("UPDATE nota_angkut SET total_awal='$total_awal', total_akhir='$total_akhir', total='$total', terbayar='$terbayar' WHERE idnotaangkut='$idnotaangkut' LIMIT 1");
    }
}
?>